/*
 * @file oledc_fontLargeSerif.h
 *
 * @author Matthew Matz
 *
 * @version 0.9
 *
 * @copyright Copyright (C) Parallax, Inc. 2016.  See end of file for
 * terms of use (MIT License).
 *
 * @brief 0.96-inch RGB OLED display font component, see oledc_.h for documentation.
 *
 * @detail Please submit bug reports, suggestions, and improvements to
 * this code to editor@parallax.com.
 */

char font_lg_index[] = {   // character index of the bitfield - must be summed
0x01, 0x0A, 0x0A, 0x15, 0x24, 0x2A, 0x25, 0x05, 0x0F, 0x0F, 0x0E, 0x12, 0x0A, 0x0D, 0x04, 0x0F, 0x1E, 0x0B, 0x23, 0x1F, 0x1F, 0x21, 0x22, 0x13, 0x2B, 0x23, 
0x08, 0x0D, 0x0B, 0x0D, 0x0B, 0x14, 0x2F, 0x1C, 0x29, 0x1C, 0x20, 0x24, 0x21, 0x23, 0x2B, 0x1A, 0x18, 0x27, 0x1E, 0x28, 0x25, 0x1E, 0x23, 0x25, 0x27, 
0x25, 0x1E, 0x1D, 0x17, 0x20, 0x25, 0x1E, 0x22, 0x10, 0x11, 0x10, 0x0C, 0x11, 0x08, 0x19, 0x1B, 0x18, 0x1F, 0x19, 0x20, 0x26, 0x1F, 0x17, 0x16, 0x1D, 
0x16, 0x1C, 0x1B, 0x16, 0x1E, 0x1E, 0x1B, 0x18, 0x17, 0x16, 0x13, 0x19, 0x1C, 0x20, 0x18, 0x11, 0x06, 0x12, 0x0A, 
};

char font_lg_zeroMap[] = {   // 7 byte wide map of zero bytes in the font
0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x5B, 0x00, 0x16, 0xC0, 0x00, 
0x00, 0x24, 0xB7, 0x6B, 0x66, 0xD2, 0x00, 
0x00, 0x4F, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 
0x0F, 0xFF, 0xDB, 0x7F, 0xFF, 0xFF, 0x40, 
0x03, 0x6F, 0xFF, 0xFF, 0xED, 0xB6, 0xC0, 
0x00, 0x00, 0x00, 0x2D, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x17, 0xF6, 0xDA, 0x00, 0x00, 
0x00, 0x00, 0x2D, 0xB7, 0xF4, 0x00, 0x00, 
0x00, 0x00, 0xDA, 0x6D, 0x36, 0x00, 0x00, 
0x01, 0x24, 0x92, 0xFD, 0x24, 0x92, 0x00, 
0x00, 0x00, 0x36, 0xDB, 0x00, 0x00, 0x00, 
0x00, 0x24, 0x92, 0x49, 0x24, 0x92, 0x00, 
0x00, 0x00, 0x04, 0x92, 0x00, 0x00, 0x00, 
0x00, 0x49, 0x26, 0x49, 0x32, 0x49, 0x00, 
0x01, 0x7F, 0x6D, 0xB6, 0xDB, 0xFA, 0x00, 
0x00, 0x00, 0x09, 0x24, 0xFE, 0x00, 0x00, 
0x00, 0x5F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 
0x00, 0x49, 0x6D, 0xFF, 0xFF, 0xFE, 0x00, 
0x00, 0x6D, 0xB7, 0xFF, 0xFD, 0xB6, 0x00, 
0x00, 0x4F, 0xFF, 0xFF, 0xFF, 0xD8, 0x00, 
0x00, 0x2F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 
0x00, 0x12, 0x49, 0xBD, 0xB6, 0x49, 0x00, 
0x03, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 
0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xD8, 0x00, 
0x00, 0x00, 0x06, 0xDB, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x06, 0xFF, 0xE0, 0x00, 0x00, 
0x00, 0x00, 0x12, 0x5B, 0x6C, 0x00, 0x00, 
0x00, 0x24, 0x92, 0x49, 0x24, 0x92, 0x00, 
0x00, 0x00, 0x36, 0xD9, 0x24, 0x00, 0x00, 
0x00, 0x02, 0x49, 0xBF, 0xF6, 0xC8, 0x00, 
0xDE, 0xFF, 0xFF, 0xB7, 0xFF, 0xFF, 0xE0, 
0x02, 0x49, 0xB7, 0xEF, 0xFD, 0xA4, 0x80, 
0x02, 0xDB, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 
0x01, 0x3F, 0x6D, 0xB6, 0xDB, 0xD9, 0x00, 
0x02, 0xDB, 0xFD, 0xB6, 0xDB, 0xFB, 0x00, 
0x02, 0xDB, 0xFF, 0xFF, 0xFB, 0x7B, 0x00, 
0x02, 0x5B, 0x7F, 0xFF, 0xF6, 0x4B, 0x60, 
0x01, 0x7F, 0x6D, 0xB7, 0xFF, 0xFE, 0x40, 
0xB6, 0xFF, 0xFF, 0x5F, 0xFF, 0xED, 0xA0, 
0x00, 0x5B, 0x6D, 0xFE, 0xDB, 0x68, 0x00, 
0x00, 0x6D, 0xAD, 0xB7, 0xF2, 0x49, 0x00, 
0x16, 0xFF, 0xFF, 0x7F, 0xFB, 0x6D, 0x80, 
0x02, 0xDB, 0x7F, 0xB6, 0xDB, 0x26, 0xC0, 
0xB7, 0xFB, 0xDE, 0xD9, 0xFB, 0xFD, 0xA0, 
0xB6, 0xFF, 0x6F, 0x6D, 0xFF, 0xC9, 0x20, 
0x01, 0x7F, 0x6D, 0xB6, 0xDB, 0xFA, 0x00, 
0x02, 0xDB, 0xFF, 0xFF, 0xF6, 0xDB, 0x00, 
0x01, 0x7F, 0xFF, 0xFF, 0xDB, 0xFE, 0x00, 
0x02, 0xDB, 0xFF, 0xFF, 0xBF, 0xFF, 0x80, 
0x00, 0x4F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
0x01, 0xBB, 0x6D, 0xFE, 0xDB, 0x5B, 0x00, 
0x00, 0x9F, 0xED, 0xB2, 0xDB, 0xF9, 0x20, 
0x00, 0x92, 0x5B, 0xF3, 0xB6, 0x49, 0x20, 
0x04, 0xBF, 0xFB, 0x2F, 0xEE, 0xD9, 0x20, 
0x96, 0xDB, 0xFF, 0x5F, 0xFB, 0x6D, 0x80, 
0x04, 0x9B, 0x7F, 0xDB, 0xFB, 0x49, 0x20, 
0x00, 0x4F, 0xFF, 0xFF, 0xFB, 0x7E, 0x00, 
0x00, 0x01, 0xFD, 0xB6, 0xD0, 0x00, 0x00, 
0x00, 0x92, 0x5B, 0x4B, 0x69, 0x20, 0x00, 
0x00, 0x01, 0x6D, 0xB7, 0xF0, 0x00, 0x00, 
0x00, 0x12, 0x49, 0x24, 0x92, 0x48, 0x00, 
0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x80, 
0x00, 0x00, 0x49, 0x24, 0x92, 0x00, 0x00, 
0x03, 0x6D, 0xB6, 0xDB, 0x6D, 0x24, 0x00, 
0x00, 0x93, 0xFE, 0xDB, 0x6D, 0xB6, 0x00, 
0x00, 0x6D, 0xB6, 0xDB, 0x6D, 0xB0, 0x00, 
0x03, 0x6D, 0xB7, 0xFF, 0xFF, 0x24, 0x00, 
0x00, 0x2D, 0xB6, 0xDB, 0x6D, 0xB6, 0x00, 
0x03, 0x6D, 0xBF, 0xFF, 0xFB, 0x49, 0x00, 
0x02, 0x6D, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 
0xB6, 0xFF, 0xB6, 0x4B, 0x6D, 0xA4, 0x80, 
0x00, 0x6D, 0xB7, 0xFE, 0x49, 0x24, 0x00, 
0x00, 0x09, 0x6D, 0xB6, 0xFF, 0xC0, 0x00, 
0x00, 0xDB, 0xFE, 0xC9, 0x6D, 0xB6, 0xC0, 
0x00, 0x5B, 0x6D, 0xFE, 0x49, 0x24, 0x00, 
0x1B, 0x6D, 0x96, 0xDB, 0x2D, 0xB4, 0x80, 
0x13, 0x6D, 0xB6, 0x4B, 0x6D, 0xB4, 0x80, 
0x00, 0x2D, 0xB6, 0xDB, 0x6D, 0x90, 0x00, 
0x00, 0x5B, 0xFF, 0xF6, 0xDF, 0xD2, 0x00, 
0x00, 0x25, 0xFD, 0xB7, 0xFF, 0xED, 0x00, 
0x1B, 0x6D, 0xB6, 0xDB, 0x64, 0x92, 0x40, 
0x00, 0x6D, 0xB6, 0xDB, 0x6D, 0xB0, 0x00, 
0x00, 0x24, 0x92, 0xFF, 0x6D, 0xB6, 0x00, 
0x01, 0x2D, 0xA4, 0x9B, 0x6D, 0xA4, 0x80, 
0x01, 0x24, 0x96, 0xD3, 0x64, 0x92, 0x40, 
0x49, 0x6D, 0xB2, 0x4B, 0x6D, 0x92, 0x40, 
0x13, 0x6D, 0xB6, 0x4B, 0x6D, 0xB6, 0x80, 
0x02, 0xDB, 0xFF, 0xFB, 0xB6, 0xC9, 0x20, 
0x00, 0x6D, 0xB6, 0xDB, 0x6D, 0xB0, 0x00, 
0x00, 0x00, 0x97, 0xFE, 0xDA, 0x00, 0x00, 
0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 
0x00, 0x0B, 0x6F, 0xFD, 0x24, 0x00, 0x00, 
0x00, 0x00, 0x12, 0x49, 0x24, 0x92, 0x00, 
};

char oled_font_lg[] = {   // bit field of the font with zero bytes removed
0x06, 0x01, 0xF8, 0x0F, 0x7F, 0xFC, 0x0F, 0x3F, 0xFC, 0x06, 0x38, 0x07, 0xFC, 0x07, 0xFC, 0x7C, 0x07, 0xFC, 0x07, 0xFC, 0xCC, 0xCC, 0xCC, 0x07, 0xEC, 0x03, 0xFF, 0x80, 0xCF, 0x80, 0xCC, 0x06, 0xCC, 0x07, 0xFC, 0xFF, 0x80, 0xCF, 0x80, 0xCC, 0xCC, 0x1C, 0x1F, 0xE0, 0xF0, 0x03, 0xE3, 0xF8, 0x07, 0x03, 0x18, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x1F, 0xFF, 0xFC, 0x1F, 0xFF, 0xFC, 0x08, 0x0C, 0x1C, 0x0C, 0x0C, 0x38, 0x0E, 0x18, 0xF8, 
0x07, 0xF9, 0xFC, 0x01, 0xE0, 0x01, 0xE0, 0x38, 0x03, 0xF0, 0x1C, 0x03, 0x38, 0x0F, 0x03, 0x1C, 0x03, 0xC3, 0x8C, 0xE1, 0xCC, 0x78, 0xFC, 0x1E, 0x7C, 0x03, 0xC7, 0x84, 0x07, 0xF3, 0xC6, 0x06, 0x38, 0xF6, 0x06, 0x1C, 0x3F, 0x07, 0x0C, 0x0F, 0x03, 0x8C, 0x07, 0x01, 0xFC, 0x01, 0x78, 0x03, 0xE0, 0x07, 0xF8, 0x0E, 0x1C, 0x78, 0x0C, 0x0F, 0xFC, 0x0C, 0x07, 0x8C, 0x0C, 0x0F, 0x0C, 0x0C, 0x19, 0x8C, 0x06, 0x70, 0xFC, 0x03, 0xE0, 0x78, 
0x03, 0xF8, 0x07, 0x3C, 0x0C, 0x06, 0x0C, 0x06, 0x0E, 0x0E, 0x07, 0x0C, 0x7C, 0x07, 0xFC, 0x07, 0xFC, 0xFF, 0x03, 0xFF, 0xC0, 0x0F, 0x81, 0xF0, 0x3C, 0x38, 0x70, 0x0E, 0xE0, 0x06, 0xC0, 0x03, 0xC0, 0x03, 0xE0, 0x06, 0x70, 0x0C, 0x3C, 0x38, 0x0F, 0x01, 0xF0, 0x03, 0xFF, 0xC0, 0xFF, 0x08, 0x80, 0x0D, 0x80, 0x05, 0x3F, 0xE0, 0x3F, 0xE0, 0x07, 0x0D, 0x80, 0x0D, 0x80, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x03, 0xFF, 0xE0, 0x03, 0xFF, 
0xE0, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x31, 0xC0, 0x33, 0xE0, 0x1B, 0xE0, 0x1F, 0xE0, 0x07, 0xC0, 0x20, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x06, 0x0F, 0x0F, 0x06, 0x40, 0x70, 0x3C, 0x0F, 0x03, 0xC0, 0xF0, 0x3C, 0x0F, 0x03, 0xC0, 0xF0, 0x3C, 0x0F, 0x03, 0x3F, 0x01, 0xFF, 0xE0, 0x03, 0xC0, 0xF0, 0x07, 0x38, 0x06, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x18, 0x07, 0x38, 
0x03, 0xC0, 0xF0, 0x01, 0xFF, 0xE0, 0x3F, 0x40, 0x60, 0x60, 0x30, 0x38, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0E, 0xE0, 0x0F, 0x80, 0xF0, 0x0D, 0xC0, 0x18, 0x0C, 0x60, 0x1C, 0x0C, 0x30, 0x0C, 0x0C, 0x18, 0x0C, 0x0C, 0x18, 0x0C, 0x0C, 0x08, 0x0C, 0x0C, 0x0C, 0x1C, 0x0C, 0x06, 0x18, 0x0C, 0x03, 0xF8, 0x08, 0x01, 0xE0, 0x80, 0xC0, 0xC0, 0x60, 0xC0, 0x30, 0xC0, 0x30, 0x60, 0x18, 0x18, 0x60, 0x18, 0x18, 0x60, 0x1C, 0x18, 0x30, 0x1C, 
0x18, 0x38, 0x3E, 0x30, 0x1C, 0x37, 0xF0, 0x0F, 0xE1, 0xC0, 0x03, 0xC0, 0x01, 0xC0, 0x01, 0xE0, 0x01, 0xB8, 0x01, 0x8E, 0x01, 0x87, 0x80, 0x01, 0x81, 0xC0, 0x01, 0x80, 0x70, 0x7F, 0xFF, 0xFC, 0x7F, 0xFF, 0xFC, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x60, 0x60, 0x1F, 0xFC, 0x60, 0x0D, 0xFC, 0x60, 0x0C, 0x0C, 0x30, 0x06, 0x0C, 0x30, 0x06, 0x0C, 0x38, 0x06, 0x0C, 0x18, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x07, 0x0C, 0x0C, 0x03, 
0xFC, 0x0C, 0xF0, 0x0C, 0xFE, 0x03, 0xFF, 0xC0, 0x07, 0x1D, 0xE0, 0x0E, 0x0C, 0x78, 0x0C, 0x06, 0x18, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x06, 0x0C, 0x06, 0x06, 0x0E, 0x0E, 0x03, 0x07, 0x1C, 0x03, 0x03, 0xF8, 0x03, 0x01, 0xF0, 0x03, 0x70, 0x7C, 0x0C, 0x0C, 0x0C, 0x7F, 0x0C, 0x7F, 0xF0, 0x0C, 0x7E, 0x0C, 0x0F, 0x8C, 0x01, 0xEC, 0x7C, 0x1C, 0x0C, 0x01, 0xE0, 0x03, 0xF1, 0xE0, 0x07, 0x3B, 0xF0, 0x06, 0x1F, 0x38, 0x0C, 0x0E, 0x18, 0x0C, 
0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x18, 0x06, 0x1F, 0x38, 0x07, 0x3B, 0xF0, 0x03, 0xF1, 0xE0, 0x01, 0xE0, 0x40, 0x07, 0xE0, 0x60, 0x0F, 0xF0, 0x60, 0x1C, 0x38, 0x60, 0x38, 0x1C, 0x30, 0x30, 0x0C, 0x30, 0x30, 0x0C, 0x18, 0x30, 0x0C, 0x0C, 0x30, 0x0C, 0x06, 0x18, 0x1C, 0x03, 0xDC, 0x38, 0x01, 0xFF, 0xF0, 0x3F, 0xC0, 0x06, 0x06, 0x0F, 0x0F, 0x0F, 0x0F, 0x06, 0x06, 0x63, 
0x87, 0x67, 0xCF, 0x80, 0x37, 0xCF, 0x80, 0x3F, 0xCF, 0x80, 0x0F, 0x87, 0x20, 0x70, 0xD8, 0x01, 0x8C, 0x03, 0x06, 0x06, 0x03, 0x04, 0x01, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0x04, 0x01, 0x06, 0x03, 0x03, 0x06, 0x01, 0x8C, 0xD8, 0x70, 0x20, 0x70, 0xF8, 0xF8, 0x0C, 0x06, 0x0C, 0x0F, 0x78, 0x0C, 0x0F, 0x7E, 0x0C, 0x06, 0x07, 0x0C, 0x03, 0x98, 0x01, 0xF8, 0xF0, 0x01, 0xFE, 0x1E, 0x03, 0xE0, 
0x38, 0x70, 0xE1, 0xF8, 0x0C, 0xC7, 0xFE, 0x0E, 0x87, 0xFF, 0x87, 0x8E, 0x07, 0xC3, 0x8C, 0x01, 0xC3, 0x06, 0x63, 0x03, 0x63, 0x07, 0xC0, 0xE3, 0x0F, 0xFF, 0xC3, 0x0F, 0xFF, 0xE3, 0x0C, 0x3F, 0xE3, 0x8C, 0x03, 0xE3, 0x03, 0x80, 0x1C, 0x01, 0xFF, 0xF8, 0x0C, 0x0C, 0x0C, 0x0F, 0x80, 0x0F, 0xF8, 0x0C, 0xFF, 0x80, 0x0C, 0xC7, 0xF8, 0xC0, 0x7C, 0x0C, 0xC7, 0xF8, 0x0C, 0xFF, 0x80, 0x0F, 0xF8, 0x0F, 0x80, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1E, 0x18, 0x06, 0x1F, 0xF0, 0x07, 0xF1, 0xE0, 0x01, 0xE0, 0x3F, 0xFF, 0xC0, 0x03, 0xC0, 0xF0, 0x07, 0x38, 0x06, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x18, 0x07, 0x78, 0x03, 0xC3, 0xF8, 0xE3, 0xFC, 0x08, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x80, 0xF0, 0x01, 0xFF, 0xE0, 0x7F, 0x80, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x7F, 0x0C, 0x0C, 0x7F, 0x0C, 0x0C, 0x0C, 0x0E, 0x3C, 0x0F, 0xE3, 0xF8, 0xE3, 0x80, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 
0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3F, 0x8C, 0xFF, 0x8C, 0x0C, 0x3C, 0x07, 0xFC, 0x07, 0x80, 0x3F, 0x01, 0xFF, 0xE0, 0x03, 0xC0, 0xF0, 0x07, 0x38, 0x06, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0E, 0x30, 0x0C, 0x07, 0x30, 0x18, 0x03, 0xF0, 0xF8, 0x07, 0xF3, 0xF8, 0x0E, 0x33, 0xFC, 0x08, 0x30, 0x30, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 
0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0xC0, 0x07, 0xE0, 0x0E, 0xE0, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0E, 0x0C, 0x07, 0xFF, 
0xFC, 0x03, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x38, 0x0C, 0x0C, 0x1C, 0x0C, 0x0C, 0x07, 0x0C, 0x1F, 0x80, 0x08, 0x39, 0xCC, 0x0C, 0xF0, 0xEC, 0x0F, 0xC0, 0x3C, 0x0F, 0x1C, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xF8, 0x0C, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 
0x0C, 0x0F, 0xF0, 0x0F, 0x80, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x1C, 0x0C, 0x03, 0xFC, 0x3F, 0xE0, 0x07, 0xFC, 0x0F, 0x80, 0x07, 0xFC, 0x7F, 0xE0, 0x0C, 0x07, 0xFC, 0x0C, 0x3C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x1C, 0x0C, 0x78, 0x0C, 0x01, 0xE0, 0x07, 0x80, 0x1E, 0x0C, 0xF8, 0x0C, 0x03, 0xC0, 
0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x3F, 0x01, 0xFF, 0xE0, 0x03, 0xC0, 0xF0, 0x07, 0x38, 0x06, 0x18, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x18, 0x07, 0x38, 0x03, 0xC0, 0xF0, 0x01, 0xFF, 0xE0, 0x3F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x06, 0x18, 0x03, 
0xF0, 0x01, 0xE0, 0x3F, 0x01, 0xFF, 0xE0, 0x03, 0xC0, 0xF0, 0x07, 0x80, 0x38, 0x07, 0xC0, 0x18, 0x0C, 0xC0, 0x0C, 0x0C, 0xC0, 0x0C, 0x0D, 0xC0, 0x0C, 0x0F, 0x80, 0x0C, 0x7F, 0x18, 0xEF, 0x38, 0xC7, 0xC0, 0xF0, 0xF1, 0xFF, 0xC0, 0x30, 0x7F, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x7C, 0x0C, 0x0F, 0xFC, 0x0C, 0x0F, 0x86, 0x18, 
0x0C, 0x03, 0xF8, 0x0C, 0x01, 0xE0, 0x0C, 0x1E, 0x1F, 0xF0, 0xF0, 0x03, 0xC1, 0xF8, 0x07, 0x03, 0x18, 0x0E, 0x02, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x06, 0x0C, 0x0C, 0x04, 0x1C, 0x0E, 0x0C, 0x38, 0x07, 0x18, 0xF8, 0x03, 0xF9, 0xFC, 0x01, 0xE0, 0x08, 0x0F, 0x80, 0x07, 0xFC, 0x0C, 0x3C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x3C, 0x0F, 0xFC, 
0x07, 0x80, 0x0C, 0x0C, 0x01, 0xFF, 0xFC, 0x03, 0xFF, 0xFC, 0x07, 0x0C, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0E, 0x0C, 0x07, 0x0C, 0x03, 0xFF, 0xFC, 0x01, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x7C, 0x07, 0xFC, 0x7F, 0x0C, 0x07, 0xF0, 0x0C, 0x0F, 0x07, 0xF0, 0x0C, 0x7F, 0x0C, 0x07, 0xFC, 0x7C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1C, 0x0F, 0xFC, 0x07, 0xFF, 0xFC, 0x0F, 0xFC, 0x0C, 0x03, 0xFF, 0x0C, 0x07, 0xFC, 0x0C, 0x03, 0xFC, 
0x01, 0xFF, 0xCC, 0x0F, 0xF8, 0x0F, 0xFC, 0x0C, 0x7F, 0xFC, 0x01, 0xFC, 0x0C, 0x0C, 0x08, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0x1C, 0x0F, 0x80, 0x7C, 0x0D, 0xE1, 0xEC, 0x0C, 0x7F, 0x8C, 0x1E, 0x0C, 0x3F, 0x0C, 0x0C, 0xF3, 0xCC, 0x0D, 0xC0, 0xFC, 0x0F, 0x3C, 0x0E, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1C, 0x0C, 0x7C, 0x0C, 0x01, 0xEC, 0x0C, 0x07, 0x8C, 0x0F, 0xFE, 0x0F, 0xFE, 0x0C, 0x07, 0x8C, 0x0C, 
0x01, 0xEC, 0x0C, 0x7C, 0x0C, 0x1C, 0x0C, 0x0C, 0x0C, 0x08, 0x0E, 0x03, 0xE0, 0x0F, 0x81, 0xFC, 0x0D, 0xC0, 0x0C, 0x0C, 0x70, 0x0C, 0x0C, 0x38, 0x0C, 0x0C, 0x0E, 0x0C, 0x0C, 0x07, 0x0C, 0x0C, 0x01, 0xCC, 0x0C, 0xEC, 0x0C, 0x3C, 0x0F, 0xE0, 0x1C, 0x07, 0xF0, 0x7F, 0xFF, 0xFE, 0x7F, 0xFF, 0xFE, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x02, 0x07, 0x1E, 0x78, 0x01, 0xE0, 0x07, 0x80, 0x1E, 0x78, 0x01, 0xE0, 0x07, 
0x80, 0x1E, 0x78, 0x60, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x7F, 0xFF, 0xFE, 0x7F, 0xFF, 0xFE, 0x60, 0x70, 0x38, 0x3C, 0x1E, 0x1F, 0x0F, 0x1F, 0x3E, 0x3C, 0x70, 0x60, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0xC0, 0x0F, 0x0F, 0x1F, 0x1E, 0x3C, 0x38, 0x70, 0x60, 0x03, 0x80, 0x07, 0xCE, 0x0E, 0x6E, 0x0C, 0x6F, 0x0C, 0x23, 0x0C, 0x23, 0x0C, 0x33, 0x06, 
0x33, 0x07, 0x37, 0x07, 0xDE, 0x0F, 0xFC, 0x0C, 0x0F, 0x07, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x07, 0x0E, 0x0E, 0x07, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0E, 0x07, 0x07, 0x0E, 0x03, 0xFC, 0x01, 0xF0, 0x01, 0xF0, 0x03, 0xFC, 0x07, 0x0E, 0x06, 0x06, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x3B, 0x0C, 0x3F, 0x06, 0x3E, 0x07, 0x1C, 0x03, 0x80, 0x01, 0xF8, 0x03, 0xFC, 0x07, 0x0E, 0x0E, 0x07, 0x0C, 0x03, 0x0C, 
0x03, 0x0C, 0x0C, 0x03, 0x0C, 0x06, 0x06, 0x0C, 0x07, 0x0E, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x60, 0x01, 0xF8, 0x03, 0x6C, 0x06, 0x66, 0x06, 0x67, 0x0C, 0x63, 0x0C, 0x63, 0x0C, 0x63, 0x0C, 0x63, 0x0E, 0x66, 0x06, 0x6E, 0x03, 0x7C, 0x01, 0x78, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0F, 0xFF, 0xC0, 0x0F, 0xFF, 0xF0, 0x0C, 0x03, 0x38, 0x0C, 0x03, 0x1C, 0x0C, 0x03, 0x0C, 0x0C, 0x03, 0x0C, 0x0C, 
0x0C, 0x0C, 0x6C, 0x78, 0x70, 0x0E, 0x1F, 0xC0, 0x33, 0xFF, 0x33, 0x3F, 0x80, 0x61, 0xF1, 0xC0, 0x61, 0xE0, 0xC0, 0x61, 0xE0, 0xC0, 0x61, 0xE0, 0xC0, 0x61, 0xB1, 0xC0, 0x61, 0xBF, 0x80, 0x33, 0x1F, 0xC0, 0x33, 0x01, 0xC0, 0x1F, 0x03, 0xC0, 0x0E, 0x01, 0x80, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x1C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x1C, 0x0C, 0x0E, 0x0C, 0x06, 0x07, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0F, 0xFE, 0x0F, 0xFC, 0x0C, 
0x0C, 0x08, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x38, 0x0F, 0xFF, 0x38, 0x0F, 0xFF, 0x38, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x08, 0x1C, 0x3E, 0xC0, 0x7E, 0xC0, 0x60, 0xC0, 0x60, 0xC0, 0x60, 0xC8, 0x60, 0xDE, 0x30, 0x07, 0xDE, 0x3F, 0xFF, 0xDE, 0x0F, 0x80, 0x08, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x20, 0x0C, 0x10, 0x3B, 0x6F, 0x0D, 0xC7, 0x0F, 0x03, 0x0E, 0x03, 0x0C, 0x03, 
0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0F, 0xFF, 0xFC, 0x0F, 0xFF, 0xFC, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x0C, 0x03, 0x0F, 0xFF, 0x0F, 0xFF, 0x0C, 0x06, 0x03, 0x0C, 0x03, 0x0F, 0xFF, 0x0F, 0xFE, 0x0C, 0x0E, 0x07, 0x08, 0x03, 0x0C, 0x03, 0x0F, 0xFE, 0x0F, 0x0C, 0x0C, 0x0C, 0x03, 0x0C, 0x03, 0x0F, 0xFF, 0x0F, 0xFF, 0x0C, 0x1C, 0x0C, 0x0E, 0x06, 0x03, 0x08, 0x03, 0x0C, 
0x03, 0x0C, 0x07, 0x0F, 0xFE, 0x0F, 0xFC, 0x0C, 0x0C, 0xF0, 0x03, 0xFC, 0x07, 0x0E, 0x06, 0x06, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x06, 0x06, 0x07, 0x0E, 0x03, 0xFC, 0xF0, 0x60, 0xC0, 0x60, 0xC0, 0x7F, 0xFF, 0xC0, 0x7F, 0xFF, 0xC0, 0x61, 0xC3, 0x80, 0x63, 0x81, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0x81, 0xC0, 0x01, 0xC3, 0x80, 0xFF, 0x7E, 0x3E, 0xFF, 0x01, 0xC3, 0x80, 0x03, 0x81, 0xC0, 0x03, 0xC0, 0x03, 
0xC0, 0x03, 0xC0, 0x63, 0x81, 0xC0, 0x61, 0xC3, 0x80, 0x7F, 0xFF, 0xC0, 0x7F, 0xFF, 0xC0, 0x60, 0xC0, 0x60, 0xC0, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0F, 0xFF, 0x0F, 0xFF, 0x0C, 0x38, 0x0C, 0x0C, 0x0C, 0x06, 0x0C, 0x06, 0x0C, 0x03, 0x1B, 0x3B, 0x3B, 0x3E, 0x1C, 0x0F, 0xDC, 0x0F, 0xDE, 0x07, 0xB7, 0x06, 0x23, 0x0C, 0x23, 0x0C, 0x23, 0x0C, 0x23, 0x0C, 0x23, 0x0C, 0x66, 0x0E, 0x6E, 0x07, 0xDF, 0x03, 0x9F, 0x03, 0x03, 
0x03, 0x03, 0x03, 0x03, 0xFF, 0xF8, 0x07, 0xFF, 0xF8, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x06, 0x03, 0x07, 0xC3, 0x01, 0xC3, 0x03, 0x03, 0x03, 0xFF, 0x07, 0xFF, 0x0C, 0x0C, 0x0C, 0x0C, 0x03, 0x06, 0x03, 0x07, 0x03, 0x03, 0xFF, 0x0F, 0xFF, 0x0C, 0x0C, 0x0C, 0x03, 0x03, 0x07, 0x1F, 0xFB, 0x03, 0xE3, 0x0F, 0x80, 0x0E, 0x0F, 0x80, 0x03, 0xE3, 0xFB, 0x1F, 0x07, 0x03, 0x03, 0x03, 0x03, 0x1F, 0x01, 0xFF, 0x0F, 0xE3, 0x0F, 0xC0, 0x03, 
0xFB, 0x3F, 0x03, 0x3F, 0x03, 0xFB, 0x0F, 0xC0, 0x0F, 0xE3, 0x01, 0xFF, 0x1F, 0x03, 0x03, 0x0C, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0E, 0x07, 0x0F, 0x0F, 0x0D, 0x9B, 0xF3, 0xF3, 0x0F, 0x9B, 0x0F, 0x0F, 0x0E, 0x07, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x03, 0x0C, 0x1C, 0xC0, 0x3E, 0xC0, 0x7E, 0xC0, 0x66, 0x01, 0xC0, 0x60, 0x07, 0xC0, 0x70, 0x3E, 0xC0, 0x38, 0xF0, 0xC0, 0x1F, 0xC0, 0x07, 0xE0, 0xC0, 0x7C, 0xC0, 0x1F, 0xC0, 0x03, 0xC0, 
0xC0, 0xC0, 0xC0, 0x0C, 0x3C, 0x0E, 0x3F, 0x0F, 0x03, 0x0D, 0x83, 0x0C, 0xC3, 0x0C, 0x63, 0x0C, 0x33, 0x0C, 0x1B, 0x0C, 0x0F, 0x0C, 0x07, 0x0F, 0xC3, 0x03, 0xC0, 0x30, 0x78, 0x3F, 0xEF, 0xFC, 0x7F, 0xCF, 0xFE, 0xFF, 0x03, 0xFF, 0xE0, 0x07, 0xC0, 0x03, 0xC0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xC0, 0x03, 0xE0, 0x07, 0xFF, 0x03, 0xFF, 0x7F, 0xCF, 0xFE, 0x3F, 0xEF, 0xFC, 0x78, 0x30, 0x30, 0x06, 0x07, 0x03, 0x03, 
0x06, 0x06, 0x0C, 0x0C, 0x06, 0x02
};  



/**
 * TERMS OF USE: MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
